/*****************************************************************************
 *   adc.c:  ADC module file for NXP LPC29xx Family Microprocessors
 *
 *   Copyright(C) 2007, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2007.08.15  ver 1.00    Preliminary version, first Release
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/

#include "LPC29xx.h"                        /* LPC29xx definitions */
#include "type.h"
#include "irq.h"
#include "target.h"
#include "adc.h"
#include "dma.h"
#include "FOC.h"

extern volatile FOC_STRUCT FOC;

/******************************************************************************
** Function name:		ADC1Handler
**
** Descriptions:		ADC1 interrupt handler
**
** parameters:			None
** Returned value:		None
**
******************************************************************************/
void ADC1_Handler (void)
{
	DWORD regVal;
	
	regVal = ADC1_INT_STATUS;
	if(regVal&(0x01<<0))									// check EOS error first
	{ 
		FOC.adcVal[0] = ADC1_ACD1 & 0x3FF;					// Save ADC 1 value
		ADC1_INT_CLR_STATUS |= (0x01<<0);
	}
	if(regVal&(0x01<<1))ADC1_INT_CLR_STATUS |= (0x01<<1);	// ADC1 Compare 
	return;
}

/******************************************************************************
** Function name:		ADC2Handler
**
** Descriptions:		ADC2 interrupt handler
**
** parameters:			None
** Returned value:		None
**
******************************************************************************/
void ADC2_Handler (void)
{
	DWORD regVal;
	
	regVal = ADC2_INT_STATUS;
	if(regVal&(0x01<<0))									// check EOS error first
	{ 
		FOC.adcVal[0] = ADC1_ACD1 & 0x3FF;					// Save ADC 1 value	channel 1
		FOC.adcVal[1] = ADC2_ACD1 & 0x3FF;					// Save ADC 2 value channel 3
		ADC2_INT_CLR_STATUS |= (0x01<<0);
		if(FOC.enabled && !FOC.busy)FOC_loop();
	}
	if(regVal&(0x01<<1))ADC2_INT_CLR_STATUS |= (0x01<<1);	// ADC2 Compare 
  	return;
}

/*****************************************************************************
** Function name:		ADC1&2_Init
**
** Descriptions:		initialize ADC channel
**
** parameters:			None
** Returned value:		None
**
*****************************************************************************/
void ADC_1_2_Init( void )
{
	CGU_FDIV_CONF1 = (0x02<<24)|(1<<12)|(54<<0);		// FDIV1 = 4.444 MHz from 240MHz PLL. 
	while ( !(CGU_RDET & (0x01<<6)) );					// Make sure FDIV1 is present.
	ADC_CLK_CONF = CLK_SEL_PLL_FDIV1 | AUTOBLK | DIV1;	// 10 bits resolution : ADC = 4.444MHz/11 = 404 kHz	
	
	SFSP0_9 = (1<<0);									// Analog input, func. 1. : ADC1_IN1
	SFSP0_17 = (1<<0);									// Analog input, func. 1. : ADC2_IN1
	
	ADC1_ACC1 = 0x0A;									// Enable AD1 channel 1 : 10-bit resolution
	ADC2_ACC1 = 0x0A;									// Enable AD2 channel 1 : 10-bit resolution
	  	
	ADC1_CONFIG &= ~(1<<0);								// ADC1 single scan.
	ADC2_CONFIG &= ~(1<<0);								// ADC2 single scan.
	
	ADC1_CONFIG |= (1<<15)|(1<<14);						// Start on MSCSS timer0 match1 toggle 
	ADC2_CONFIG |= (1<<15)|(1<<14);						// Start on MSCSS timer0 match2 toggle
	
	ADC1_CTRL = ((1<<0)|(1<<2));						// Set both start and update bits. 	  	
	ADC2_CTRL = ((1<<0)|(1<<2));						// Set both start and update bits. 	  	

	/* Install and enable the ADC2 interrupt */
  	install_irq( ADC2_INT, (void *)ADC2_Handler, HIGHEST_PRIORITY );
  	EnableIntReq_IRQ( ADC2_INT, ACTIVE_HIGH, HIGHEST_PRIORITY );

  	/* Enable both Comp/match and EOS interrupts on ADC2 */
	ADC2_INT_SET_ENABLE = 0x03;
  	return;
}

